/*
 * Decompiled with CFR 0.152.
 */
package com.neuro.pack.network;

import java.util.Arrays;

public class NeuralNetwork {
    private final double learningRate;
    private double[][] weightInputHidden;
    private double[][] weightHiddenOutput;

    public NeuralNetwork(int inputNodes, int hiddenNodes, int outputNodes, double learningRate) {
        this.learningRate = learningRate;
        this.weightInputHidden = this.randomWeight(hiddenNodes, inputNodes);
        this.weightHiddenOutput = this.randomWeight(outputNodes, hiddenNodes);
    }

    private double[][] randomWeight(int rows, int cols) {
        double[][] res = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                res[i][j] = Math.random() - 0.5;
            }
        }
        return res;
    }

    public void train(double[] inputList, double[] targetList) {
        double[][] input = this.createDoubleArray(inputList);
        double[][] target = this.createDoubleArray(targetList);
        double[][] hiddenInputs = this.multiplyMatrices(this.weightInputHidden, input);
        double[][] hiddenOutputs = this.sigmoidArrays(hiddenInputs);
        double[][] finalInputs = this.multiplyMatrices(this.weightHiddenOutput, hiddenOutputs);
        double[][] finalOutputs = this.sigmoidArrays(finalInputs);
        double[][] outputErrors = this.minusMatrices(finalOutputs, target);
        double[][] hiddenErrors = this.multiplyMatrices(this.transponeMatrix(this.weightHiddenOutput), outputErrors);
        double[][] who1 = this.oneMinusMatrix(finalOutputs);
        double[][] who2 = this.multiplyMatrices(finalOutputs, who1);
        double[][] who3 = this.multiplyMatrices(outputErrors, who2);
        double[][] who4 = this.transponeMatrix(hiddenOutputs);
        double[][] who5 = this.multiplyMatrices(who3, who4);
        double[][] who6 = this.multiplyMatricesToNumber(who5, this.learningRate);
        this.weightHiddenOutput = this.plusMatrices(this.weightHiddenOutput, who6);
        double[][] whi1 = this.oneMinusMatrix(hiddenOutputs);
        double[][] whi2 = this.multiplyMatrices(hiddenOutputs, whi1);
        double[][] whi3 = this.multiplyMatrices(hiddenErrors, whi2);
        double[][] whi4 = this.transponeMatrix(input);
        double[][] whi5 = this.multiplyMatrices(whi3, whi4);
        double[][] whi6 = this.multiplyMatricesToNumber(whi5, this.learningRate);
        this.weightInputHidden = this.plusMatrices(this.weightInputHidden, whi6);
    }

    private double[][] plusMatrices(double[][] output, double[][] target) {
        double[][] result = new double[output.length][output[0].length];
        for (int i = 0; i < output.length; ++i) {
            for (int j = 0; j < output[0].length; ++j) {
                result[i][j] = target[i][j] + output[i][j];
            }
        }
        return result;
    }

    private double[][] multiplyMatricesToNumber(double[][] matrix, double number) {
        double[][] tmpMatrix = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                tmpMatrix[i][j] = matrix[i][j] * number;
            }
        }
        return tmpMatrix;
    }

    private double[][] oneMinusMatrix(double[][] finalOutputs) {
        double[][] ones;
        for (double[] one : ones = new double[finalOutputs.length][finalOutputs[0].length]) {
            Arrays.fill(one, 1.0);
        }
        return this.minusMatrices(finalOutputs, ones);
    }

    private double[][] transponeMatrix(double[][] paramMatrix) {
        double[][] tmpMatrix = new double[paramMatrix[0].length][paramMatrix.length];
        for (int i = 0; i < paramMatrix[0].length; ++i) {
            for (int j = 0; j < paramMatrix.length; ++j) {
                tmpMatrix[i][j] = paramMatrix[j][i];
            }
        }
        return tmpMatrix;
    }

    private double[][] minusMatrices(double[][] output, double[][] target) {
        double[][] result = new double[output.length][output[0].length];
        for (int i = 0; i < output.length; ++i) {
            for (int j = 0; j < output[0].length; ++j) {
                result[i][j] = target[i][j] - output[i][j];
            }
        }
        return result;
    }

    private double[][] sigmoidArrays(double[][] data) {
        double[][] res = new double[data.length][1];
        for (int i = 0; i < data.length; ++i) {
            res[i][0] = this.sigmoid(data[i][0]);
        }
        return res;
    }

    private double sigmoid(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    private double[][] multiplyMatrices(double[][] firstMatrix, double[][] secondMatrix) {
        double[][] res = new double[firstMatrix.length][secondMatrix[0].length];
        if (firstMatrix[0].length == 1 && secondMatrix[0].length == 1) {
            for (int row = 0; row < res.length; ++row) {
                for (int col = 0; col < res[row].length; ++col) {
                    res[row][col] = firstMatrix[row][col] * secondMatrix[row][col];
                }
            }
        } else {
            for (int row = 0; row < res.length; ++row) {
                for (int col = 0; col < res[row].length; ++col) {
                    res[row][col] = this.multiplyMatricesCell(firstMatrix, secondMatrix, row, col);
                }
            }
        }
        return res;
    }

    private double multiplyMatricesCell(double[][] firstMatrix, double[][] secondMatrix, int row, int col) {
        double cell = 0.0;
        for (int i = 0; i < secondMatrix.length; ++i) {
            cell += firstMatrix[row][i] * secondMatrix[i][col];
        }
        return cell;
    }

    private double[][] createDoubleArray(double[] data) {
        double[][] res = new double[data.length][1];
        for (int i = 0; i < data.length; ++i) {
            res[i][0] = data[i];
        }
        return res;
    }

    public double[] query(double[] inputList) {
        double[][] input = this.createDoubleArray(inputList);
        double[][] hiddenInputs = this.multiplyMatrices(this.weightInputHidden, input);
        double[][] hiddenOutputs = this.sigmoidArrays(hiddenInputs);
        double[][] finalInputs = this.multiplyMatrices(this.weightHiddenOutput, hiddenOutputs);
        double[][] finalOutputs = this.sigmoidArrays(finalInputs);
        double[] result = new double[finalOutputs.length];
        for (int i = 0; i < finalOutputs.length; ++i) {
            result[i] = finalOutputs[i][0];
        }
        return result;
    }
}

