/*
 * Decompiled with CFR 0.152.
 */
package com.neuro.pack.ui;

import com.neuro.pack.intefaces.OnNetworkParamsListener;
import com.neuro.pack.intefaces.OnUiParamsListener;
import com.neuro.pack.ui.Favicon;
import com.neuro.pack.ui.MainPanel;
import com.neuro.pack.ui.dialogs.FileChooser;
import com.neuro.pack.ui.dialogs.HelpDialog;
import com.neuro.pack.ui.dialogs.InfoDialog;
import com.neuro.pack.ui.menu.AboutMenu;
import com.neuro.pack.ui.menu.FileMenu;
import com.neuro.pack.ui.menu.OnClickMenuListener;
import com.neuro.pack.ui.menu.TypeMenu;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;

public class MainFrame
extends JFrame
implements OnClickMenuListener,
OnNetworkParamsListener {
    private final MainPanel panel;
    private OnUiParamsListener neuroListener;
    private boolean isLearnNetwork;

    public MainFrame() {
        this.setIconImage(new Favicon().getImage());
        this.setDefaultCloseOperation(3);
        this.setTitle("\u0420\u0430\u0441\u043f\u043e\u0437\u043d\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0446\u0438\u0444\u0440 \u043e\u0442 0 \u0434\u043e 9");
        this.setSize(600, 570);
        this.setLocationRelativeTo(null);
        this.setJMenuBar(this.createMenuBar());
        this.panel = new MainPanel();
        this.setContentPane(this.panel);
        this.setVisible(true);
        this.setResizable(false);
        this.isLearnNetwork = false;
    }

    private JMenuBar createMenuBar() {
        JMenuBar bar = new JMenuBar();
        bar.add(new FileMenu(this));
        bar.add(new AboutMenu(this));
        return bar;
    }

    @Override
    public void onClickMenu(TypeMenu typeMenu) {
        switch (typeMenu) {
            case EXIT_APP: {
                this.dispose();
                break;
            }
            case OPEN_FILE: {
                this.openImage();
                break;
            }
            case AUTHOR_APP: {
                this.openDialogInfo();
                break;
            }
            case HELP_APP: {
                this.openDialogHelp();
            }
        }
    }

    private void openDialogHelp() {
        HelpDialog helpDialog = new HelpDialog(this);
        helpDialog.showDialog();
    }

    private void openDialogInfo() {
        InfoDialog infoDialog = new InfoDialog(this);
        infoDialog.showDialog();
    }

    private void openImage() {
        try {
            FileChooser chooser = new FileChooser(this);
            File file = chooser.getFile();
            if (file != null) {
                BufferedImage icon = ImageIO.read(file);
                if (icon.getWidth() == 28 && icon.getHeight() == 28) {
                    this.panel.setFile(icon, !this.isLearnNetwork);
                    this.neuroListener.onUiImage(icon);
                } else {
                    this.showErrorDialog("\u0420\u0430\u0437\u043c\u0435\u0440 \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0438 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c 28 x 28");
                    this.panel.errorFile();
                }
            }
        }
        catch (IOException e) {
            this.showErrorDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0431\u043e\u0440\u0430 \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0438");
            this.panel.errorFile();
        }
    }

    private void showErrorDialog(String message) {
        JOptionPane.showMessageDialog(this, message, "\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f", 0);
    }

    public void setOnUiParamsListener(OnUiParamsListener paramsListener) {
        this.neuroListener = paramsListener;
        this.panel.setOnUiParamsListener(paramsListener);
    }

    @Override
    public void onNotTrainFile() {
        this.showErrorDialog("\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043d\u0430\u0439\u0442\u0438 \u0442\u0440\u0435\u043d\u0438\u0440\u043e\u0432\u043e\u0447\u043d\u044b\u0439 \u0444\u0430\u0439\u043b mnist_train.bin");
    }

    @Override
    public void onErrorImage() {
        this.showErrorDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0431\u0443\u0444\u0435\u0440\u0430");
    }

    @Override
    public void onCurrentProgress(int epoch) {
        this.panel.setCurrentProgress(epoch);
    }

    @Override
    public void onOffLearningBtn() {
        this.panel.setOffLearningBtn();
    }

    @Override
    public void onNetworkTrained() {
        this.panel.setNetworkTrained();
        this.isLearnNetwork = true;
    }

    @Override
    public void onResultNetwork(double[] result) {
        this.panel.setResultNetwork(result);
    }

    @Override
    public void onAnswer(int result) {
        this.panel.setAnswer(result);
    }
}

