/*
 * Decompiled with CFR 0.152.
 */
package com.neuro.pack.ui;

import com.neuro.pack.enums.ParamsType;
import com.neuro.pack.intefaces.OnUiParamsListener;
import com.neuro.pack.ui.buttons.DefiningButton;
import com.neuro.pack.ui.buttons.LearningButton;
import com.neuro.pack.ui.buttons.OnClickListener;
import com.neuro.pack.ui.buttons.ResetButton;
import com.neuro.pack.ui.buttons.TypeClick;
import com.neuro.pack.ui.params.ParamPanel;
import com.neuro.pack.ui.result.ResultPanel;
import com.neuro.pack.ui.sliders.OnSliderListener;
import com.neuro.pack.ui.sliders.SlideController;
import com.neuro.pack.ui.sliders.TypeSlider;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MainPanel
extends JPanel
implements OnSliderListener,
OnClickListener {
    public static final int SIZE_IMAGE_NUMBER = 240;
    private final JLabel label;
    private final ParamPanel paramPanel;
    private final ResultPanel resultPanel;
    private final SlideController slideController;
    private OnUiParamsListener listener;
    private JButton learningBtn;
    private JButton definingBtn;
    private JButton resetBtn;
    private final JLabel answer;

    public MainPanel() {
        this.setLayout(null);
        this.label = new JLabel();
        this.label.setBounds(15, 15, 240, 240);
        this.label.setBorder(BorderFactory.createTitledBorder("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0447\u0438\u0441\u043b\u043e"));
        this.add(this.label);
        this.slideController = new SlideController(this);
        this.slideController.setOnSliderListener(this);
        this.paramPanel = new ParamPanel();
        this.add(this.paramPanel);
        this.resultPanel = new ResultPanel();
        this.add(this.resultPanel);
        this.answer = new JLabel("X");
        this.answer.setFont(new Font("Verdana", 1, 110));
        this.answer.setBounds(470, 300, 100, 150);
        this.answer.setBorder(BorderFactory.createLineBorder(Color.ORANGE));
        this.answer.setHorizontalAlignment(0);
        this.add(this.answer);
        this.initButton();
    }

    private void initButton() {
        this.learningBtn = new LearningButton(this, this);
        this.definingBtn = new DefiningButton(this, this);
        this.resetBtn = new ResetButton(this, this);
    }

    public void setFile(BufferedImage icon, boolean isLearn) {
        Image image = icon.getScaledInstance(240, 240, 1);
        this.label.setIcon(new ImageIcon(image));
        this.label.setBorder(BorderFactory.createTitledBorder("\u0427\u0438\u0441\u043b\u043e \u0432\u044b\u0431\u0440\u0430\u043d\u043e"));
        this.slideController.enabled(isLearn);
        this.learningBtn.setEnabled(isLearn);
    }

    public void errorFile() {
        this.label.setIcon(null);
        this.label.setBorder(BorderFactory.createTitledBorder("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0447\u0438\u0441\u043b\u043e"));
        this.slideController.enabled(false);
        this.learningBtn.setEnabled(false);
        this.definingBtn.setEnabled(false);
        this.resetBtn.setEnabled(false);
    }

    @Override
    public void onSlide(TypeSlider type, int current) {
        this.paramPanel.updateParams(type, current);
        switch (type) {
            case SLIDER_HIDDEN: {
                this.listener.onUiParams(ParamsType.PARAMS_HIDDEN, current);
                break;
            }
            case SLIDER_EPOCH: {
                this.listener.onUiParams(ParamsType.PARAMS_EPOCH, current);
                break;
            }
            case SLIDER_RATIO: {
                this.listener.onUiParams(ParamsType.PARAMS_RATIO, current);
            }
        }
    }

    public void setOnUiParamsListener(OnUiParamsListener paramsListener) {
        this.listener = paramsListener;
    }

    @Override
    public void onClick(TypeClick type) {
        this.listener.onUiClick(type);
        switch (type) {
            case LEARNING_BTN: {
                this.definingBtn.setEnabled(false);
                this.resetBtn.setEnabled(false);
                break;
            }
            case DEFINING_BTN: {
                this.learningBtn.setEnabled(false);
                break;
            }
            case RESET_BTN: {
                this.definingBtn.setEnabled(false);
                this.resetBtn.setEnabled(false);
                this.learningBtn.setEnabled(true);
                this.slideController.enabled(true);
                this.slideController.refresh();
                this.paramPanel.refresh();
            }
        }
    }

    public void setCurrentProgress(int epoch) {
        this.paramPanel.updateParams(TypeSlider.SLIDER_CURRENT_EPOCH, epoch);
    }

    public void setOffLearningBtn() {
        this.learningBtn.setEnabled(false);
        this.slideController.enabled(false);
    }

    public void setNetworkTrained() {
        this.definingBtn.setEnabled(true);
        this.resetBtn.setEnabled(true);
    }

    public void setResultNetwork(double[] result) {
        this.resultPanel.setResult(result);
    }

    public void setAnswer(int result) {
        this.answer.setText(result + "");
    }
}

