/*
 * Decompiled with CFR 0.152.
 */
package com.neuro.pack.ui.sliders;

import com.neuro.pack.ui.sliders.OnSliderListener;
import com.neuro.pack.ui.sliders.labels.CountEpochLabel;
import com.neuro.pack.ui.sliders.labels.HiddenLayerLabel;
import com.neuro.pack.ui.sliders.labels.LearningRateLabel;
import com.neuro.pack.ui.sliders.progress.CountEpochProgress;
import com.neuro.pack.ui.sliders.progress.HiddenLayerProgress;
import com.neuro.pack.ui.sliders.progress.LearningRateProgress;
import javax.swing.JPanel;

public class SlideController {
    private OnSliderListener listener;
    private final JPanel panel;
    private HiddenLayerProgress hiddenLayerProgress;
    private CountEpochProgress countEpochProgress;
    private LearningRateProgress learningRateProgress;

    public SlideController(JPanel panel) {
        this.panel = panel;
    }

    public void setOnSliderListener(OnSliderListener listener) {
        this.listener = listener;
        this.createSliders();
    }

    private void createSliders() {
        new HiddenLayerLabel(this.panel);
        new CountEpochLabel(this.panel);
        new LearningRateLabel(this.panel);
        this.hiddenLayerProgress = new HiddenLayerProgress(this.panel, this.listener);
        this.countEpochProgress = new CountEpochProgress(this.panel, this.listener);
        this.learningRateProgress = new LearningRateProgress(this.panel, this.listener);
        this.enabled(false);
    }

    public void enabled(boolean status) {
        this.hiddenLayerProgress.isActive(status);
        this.countEpochProgress.isActive(status);
        this.learningRateProgress.isActive(status);
    }

    public void refresh() {
        this.hiddenLayerProgress.setValue(50);
        this.countEpochProgress.setValue(1);
        this.learningRateProgress.setValue(28);
    }
}

