/*
 * Decompiled with CFR 0.152.
 */
package com.neuro.pack.ui.sliders.progress;

import com.neuro.pack.ui.sliders.OnSliderListener;
import com.neuro.pack.ui.sliders.TypeSlider;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public abstract class BaseProgress
extends JSlider {
    private static final int Y_COORDS = 15;
    private static final int HEIGHT = 240;

    public BaseProgress(JPanel panel, OnSliderListener listener) {
        this.setOrientation(1);
        this.setMinimum(this.minValue());
        this.setMaximum(this.maxValue());
        this.setValue(this.currentValue());
        this.setBounds(this.xCoords(), 15, this.widthProgress(), 240);
        this.setPaintLabels(true);
        this.setMajorTickSpacing(this.tickSpacing());
        this.setPaintTicks(true);
        if (this.cardLabel() != null) {
            this.setLabelTable(this.cardLabel());
        }
        panel.add(this);
        this.addChangeListener(e -> {
            JSlider source = (JSlider)e.getSource();
            listener.onSlide(this.type(), source.getValue());
        });
    }

    abstract int minValue();

    abstract int maxValue();

    abstract int currentValue();

    abstract int xCoords();

    abstract int widthProgress();

    abstract int tickSpacing();

    abstract Hashtable<Integer, JLabel> cardLabel();

    abstract TypeSlider type();

    public void isActive(boolean status) {
        this.setEnabled(status);
    }
}

